/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.math.PixelBuffer;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class QuestShape
extends Icon {
    public static final Map<String, QuestShape> MAP = new LinkedHashMap<String, QuestShape>();
    private static QuestShape defaultShape;
    public static NameMap<String> idMap;
    public static NameMap<String> idMapWithDefault;
    public final String id;
    public final ImageIcon background;
    public final ImageIcon outline;
    public final ImageIcon shape;
    private PixelBuffer shapePixels;

    public static void reload(List<String> list) {
        MAP.clear();
        for (String s : list) {
            MAP.put(s, new QuestShape(s));
        }
        defaultShape = MAP.values().iterator().next();
        idMap = NameMap.of((Object)list.get(0), (Object[])list.toArray(new String[0])).baseNameKey("ftbquests.quest.shape").create();
        list.add(0, "default");
        idMapWithDefault = NameMap.of((Object)list.get(0), (Object[])list.toArray(new String[0])).baseNameKey("ftbquests.quest.shape").create();
    }

    public static QuestShape get(String id) {
        return MAP.getOrDefault(id, defaultShape);
    }

    public QuestShape(String i) {
        this.id = i;
        this.background = new ImageIcon(new ResourceLocation("ftbquests", "textures/shapes/" + this.id + "/background.png"));
        this.outline = new ImageIcon(new ResourceLocation("ftbquests", "textures/shapes/" + this.id + "/outline.png"));
        this.shape = new ImageIcon(new ResourceLocation("ftbquests", "textures/shapes/" + this.id + "/shape.png"));
    }

    public String toString() {
        return "quest_shape:" + this.id;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrixStack, int x, int y, int w, int h) {
        this.background.draw(matrixStack, x, y, w, h);
        this.outline.draw(matrixStack, x, y, w, h);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public PixelBuffer getShapePixels() {
        if (this.shapePixels == null) {
            try {
                IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation("ftbquests", "textures/shapes/" + this.id + "/shape.png"));
                try (InputStream stream = resource.func_199027_b();){
                    this.shapePixels = PixelBuffer.from((InputStream)stream);
                }
            }
            catch (Exception ex) {
                this.shapePixels = new PixelBuffer(1, 1);
                this.shapePixels.setRGB(0, 0, -1);
            }
        }
        return this.shapePixels;
    }
}

